% Written by Tobias Grafke (grafke@cims.nyu.edu), based on the
% publication
%
%    T. Grafke, T. Schäfer, and E. Vanden-Eijnden,
%    "Long-Lasting Effects of Small Random Perturbations on Dynamical
%       Systems: Theoretical and Computational Tools" (2016)
%
% available at http://arxiv.org/abs/1604.03818.
%

Nt = 2^10;
Nx = 2;

% model parameters
a1=156;
a2=30;


params.H = @(x,p) a1./(1+x(:,2).^3).*(exp(p(:,1))-1) + x(:,1).*(exp(-p(:,1))-1) ...
    + a2./(1+x(:,1)).*(exp(p(:,2))-1) + x(:,2).*(exp(-p(:,2))-1);

params.H_x = @(x,p) [(exp(-p(:,1))-1) - a2./(1+x(:,1)).^2.*(exp(p(:,2))-1), ...
              -3*a1*x(:,2).^2./(1+x(:,2).^3).^2.*(exp(p(:,1))-1) + (exp(-p(:,2))-1)];

params.H_p = @(x,p) [a1./(1+x(:,2).^3).*exp(p(:,1)) -  x(:,1).*exp(-p(:,1)), ...
              a2./(1+x(:,1)).*exp(p(:,2)) - x(:,2).*exp(-p(:,2))]

params.invH_pp = @(x,p) 1./[a1./(1+x(:,2).^3).*exp(p(:,1)) +  x(:,1).*exp(-p(:,1)), ...
                    a2./(1+x(:,1)).*exp(p(:,2)) + x(:,2).*exp(-p(:,2))];

% setup
s = linspace(0,1,Nt);
ds = s(2)-s(1);
params.xa = fsolve(@(x) H_p(x,0*x),[a1,0]);
params.xb = fsolve(@(x) H_p(x,0*x),[0,a2]);
params.xs = fsolve(@(x) H_p(x,0*x),[20,2]);

% initial trajectory
s1 = linspace(0,1-2/Nt,Nt/2);
x_initial = [repmat(params.xa,Nt/2,1) + ...
     repmat(s1',1,Nx).*repmat(params.xs-params.xa, Nt/2, 1); ...
     repmat(params.xs,Nt/2,1) + ...
     repmat(s1',1,Nx).*repmat(params.xb-params.xs, Nt/2, 1)];

disp('%%%%%%%%%%%%%%%%')
disp('String')
disp('%%%%%%%%%%%%%%%%')

params.epsilon = 5e-1;
params.iterations = 5e2;
params.plotevery = 100;

x_string = string(x_initial, params);

disp('%%%%%%%%%%%%%%%%')
disp('Minimizer')
disp('%%%%%%%%%%%%%%%%')

params.iterations = 1e3;
params.plotevery = 10;
params.epsilon = 1e-2;

x_initial = x_string;
x_minimizer = sgmam(x_initial, params);

figure(1)
plot(x_string(:,1), x_string(:,2), 'x-g', ...
     x_minimizer(:,1), x_minimizer(:,2), 'x-b', ...
     [params.xa(1),params.xs(1),params.xb(1)], ...
     [params.xa(2),params.xs(2),params.xb(2)], ...
     'ro')
grid
xlim([2.4,160])
ylim([0,4])
title('Zoom around "uphill" region')
legend('String', 'Minimizer')