% Written by Tobias Grafke (grafke@cims.nyu.edu), based on the
% publication
%
%    T. Grafke, T. Schäfer, and E. Vanden-Eijnden,
%    "Long-Lasting Effects of Small Random Perturbations on Dynamical
%       Systems: Theoretical and Computational Tools" (2016)
%
% available at http://arxiv.org/abs/1604.03818.
%

Nt = 2^8;
Nx = 3;

% model parameters
m_H = 12;
m_beta = 1.25;
m_gamma = 2;
m_k = 2;
m_U0 = 10.5;

params.H = @(x,p) (m_k*x(:,2).*(x(:,3)-m_beta/m_k^2)-m_gamma*x(:,1)).*p(:,1) + ...
           (-m_k*x(:,1).*(x(:,3)-m_beta/m_k^2)+x(:,3)*m_H/m_k-m_gamma*x(:,2)).*p(:,2) + ...
           (-0.5*x(:,2)*m_H*m_k-m_gamma*(x(:,3)-m_U0)).*p(:,3) + ...
           0.5*(p(:,1).^2 + p(:,2).^2 + p(:,3).^2);

params.H_x = @(x,p) [-m_gamma*p(:,1) - m_k*(x(:,3)-m_beta/m_k^2).*p(:,2), ...
              m_k*(x(:,3)-m_beta/m_k^2).*p(:,1) - m_gamma*p(:,2) - 0.5*m_H*m_k*p(:,3), ...
              m_k*x(:,2).*p(:,1) + (-m_k*x(:,1) + m_H/m_k).*p(:,2) - m_gamma*p(:,3)];

params.H_p = @(x,p) [(m_k*x(:,2).*(x(:,3)-m_beta/m_k^2)-m_gamma*x(:,1)) + p(:,1), ...
             (-m_k*x(:,1).*(x(:,3)-m_beta/m_k^2)+x(:,3)*m_H/m_k-m_gamma*x(:,2)) + p(:,2), ...
             (-0.5*x(:,2)*m_H*m_k-m_gamma*(x(:,3)-m_U0)) + p(:,3)];

params.invH_pp = @(x,p) 0*x+1;

% setup
s = linspace(0,1,Nt);
ds = s(2)-s(1);
params.xb = fsolve(@(x) params.H_p(x,0*x), [0.46, 1.65, 0.59], ...
                   optimset('TolFun', 1e-13));
params.xa = fsolve(@(x) params.H_p(x,0*x), [3.07, 0.39, 8.15], ...
                   optimset('TolFun', 1e-13));
params.xs = fsolve(@(x) params.H_p(x,0*x), 0.5*(params.xa+params.xb), ...
                   optimset('TolFun', 1e-13));

% initial trajectory
x_initial = repmat(params.xa,Nt,1) + ...
    repmat(s',1,Nx).*repmat(params.xb-params.xa, Nt, 1);

disp('%%%%%%%%%%%%%%%%')
disp('String')
disp('%%%%%%%%%%%%%%%%')

params.epsilon = 1e-2;
params.iterations = 1e3;
params.plotevery = 100;

x_string = string(x_initial, params);

disp('%%%%%%%%%%%%%%%%')
disp('Minimizer')
disp('%%%%%%%%%%%%%%%%')

params.iterations = 1e3;
params.plotevery = 100;
params.epsilon = 1e-3;

x_initial = x_string;
x_minimizer = sgmam(x_initial, params);
